###################################################################
# R code: Exercise 10.11(b)
# File: Hit-function.r
# Coded by:  P. Araujo Santos
#
# Reference: 
# Araujo Santos, P. (2010). 
#   Interval forecasts evaluation: R programs for a 
#   new independence test. Notas e Comunicacoes CEAUL 17/2010. 
#   Available at: http://www.ceaul.fc.ul.pt/notas.html?ano=2010.
# Araujo Santos, P. and Fraga Alves, M.I. (2012).
#   A new class of independence tests for interval forecasts evaluation.
#   Computational Statistics & Data Analysis, 56(11), 3366-3380.
#   DOI: 10.1016/j.csda.2010.10.002.
###################################################################
# Hit sequence
hit <- c(1,1,1,1,0,0,1,0,0,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1, 
         1,1,1,1,1,1,1,1,1,1,1)    # SCMI
# hit <- c(0,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,1,0,1,1,1,1,1, 
#        0,1,1,1,1,1,1,1,1,0,1)    # HDR
tt <- length(hit)
# Durations
no_hit_duration <- 0
j <- 1
zeros <- 0
for(i in 1:tt) {
  if (hit[i]<1){
     zeros <- zeros+1
   }
  else {
  no_hit_duration[j] <- zeros+1
  zeros <- 0
  j <- j+1
  }
}
no <- no_hit_duration
n  <- length(no)

# T[0.5] Independence Test
no         <- sort(no)
observed_T <-log(2)*(no[n]-1)/no[floor(0.5*n)]-log(n)
observed_T

# Simulation of the upper bound for the p-value
v    <- 0
repl <- 250000   # Number of replications
v    <- rep(0,times=repl)
for(i in 1:repl) {
  if((i/10000-floor(i/10000))==0){print(repl-i)}
  u        <- runif(n)
  y        <- -log(1-u)
  no_simul <- sort(y)
  v[i]     <- log(2)*(no_simul[n]/no_simul[floor(n/2)])-log(n)
}
simulated_upper_bound_p_value <- length(v[v>=observed_T])/repl
observed_T
simulated_upper_bound_p_value